﻿-- ürün ve kategorileri getiren sorgu
select p.ProductName [Ürün Adı], p.QuantityPerUnit Miktarı, p.UnitPrice Fiyatı, p.UnitsInStock [Stok Adedi], 
c.CategoryName as Kategori, c.Description [Kategori Açıklaması]
from Products p inner join Categories c
on p.CategoryID = c.CategoryID

-- üretilmeye devam eden ürün ve kategorileri getiren sorgu
select p.ProductName [Ürün Adı], p.QuantityPerUnit Miktarı, p.UnitPrice Fiyatı, p.UnitsInStock [Stok Adedi], 
c.CategoryName as Kategori, c.Description [Kategori Açıklaması]
from Products p inner join Categories c
on p.CategoryID = c.CategoryID
where p.Discontinued = 0

-- deniz ürünleri kategorisinde üretilmeye devam eden ürün ve kategorileri getiren sorgu
select p.ProductName [Ürün Adı], p.QuantityPerUnit Miktarı, p.UnitPrice Fiyatı, p.UnitsInStock [Stok Adedi], 
c.CategoryName as Kategori, c.Description [Kategori Açıklaması]
from Products p inner join Categories c
on p.CategoryID = c.CategoryID
where p.Discontinued = 0
and c.CategoryName = 'seafood'

-- deniz ürünleri veya içecekler kategorilerinde üretilmeye devam eden ürün ve kategorileri getiren sorgu
select p.ProductName [Ürün Adı], p.QuantityPerUnit Miktarı, p.UnitPrice Fiyatı, p.UnitsInStock [Stok Adedi], 
c.CategoryName as Kategori, c.Description [Kategori Açıklaması]
from Products p inner join Categories c
on p.CategoryID = c.CategoryID
where p.Discontinued = 0
and (c.CategoryName = 'seafood' or c.CategoryName = 'Beverages')
order by c.CategoryName, p.ProductName

-- içecek kategorisindeki tüm ürünlerin toplam stok adedini getiren sorgu
select * from Categories where CategoryID = 1
select SUM(UnitsInStock) [Toplam Stok Adedi] from Products where CategoryID = 1

-- kategorilere göre tüm ürün toplam stok adetlerini toplam stok adedi azalan şekilde getiren sorgu
select CategoryName, SUM(UnitsInStock) TotalStock from Products left outer join Categories
on Products.CategoryID = Categories.CategoryID
group by CategoryName
order by TotalStock desc -- SUM(UnitsInStock) desc

-- kategori adı, ürün adı, ürün adedi, sipariş ID'si, sipariş tarihi ve müşteri ID'ye göre tüm siparişler
create view vTumSiparisler -- create view her zaman sorgu sayfasında ilk satırda olmalı!
as
select c.CategoryName, p.ProductName, od.Quantity, od.OrderID, CONVERT(varchar(10), o.OrderDate, 101) OrderDate, 
o.CustomerID from Categories c left outer join Products p on c.CategoryID = p.CategoryID
left outer join [Order Details] od on p.ProductID = od.ProductID
left outer join Orders o on od.OrderID = o.OrderID
-- view select sorgusu
select * from vTumSiparisler

-- kategoriye göre sipariş sayısı 200'den büyük olanlar
select distinct c.CategoryID, od.OrderID from Categories c left outer join Products p on c.CategoryID = p.CategoryID
left outer join [Order Details] od on p.ProductID = od.ProductID
order by c.CategoryID, od.OrderID 
-- distinct ile çoklayan satırları teke düşürmeliyiz!
select c.CategoryName, COUNT(distinct od.OrderId) OrderCount from Categories c left outer join Products p on c.CategoryID = p.CategoryID
left outer join [Order Details] od on p.ProductID = od.ProductID
group by c.CategoryName
having COUNT(distinct od.OrderId) > 200 -- sonuç sorgusu
-- distinct ile çoklayan satırları teke düşürmeliyiz!
select CategoryName, COUNT(distinct OrderID) OrderCount from vTumSiparisler
group by CategoryName
having COUNT(distinct OrderId) > 200 -- daha önce oluşturduğumuz view üzerinden sonuç sorgusu
-- distinct ile çoklayan satırları teke düşürmeliyiz!

-- kategoriye göre en fazla ürün kayıt sayısına sahip olan kategori
select top 1 c.CategoryName, COUNT(*) ProductCount from products p, categories c where p.CategoryID = c.CategoryID
group by c.CategoryName
order by COUNT(*) desc

-- en yüksek birim fiyata sahip olan ürünün kategorisi
select categoryId, categoryname, description from categories where categoryID = (select CategoryID from products where unitprice = (select max(unitprice) from products))

-- en yüksek birim fiyata sahip ürün
select ProductId, ProductName, unitprice MaxUnitPrice from products where unitprice = (select max(unitprice) from products) -- 1. yöntem
select top 1 ProductId, ProductName, MAX(unitprice) MaxUnitPrice from products group by ProductId, ProductName order by MAX(unitprice) desc -- 2. yöntem